unit psUnit1;

{ The main program Unit
  Author: Ranjith - krranjith@crosswinds.net
          www.geocities.com/ck_senthilkumar
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, commctrl, ExtCtrls, jpeg, Masks, shlobj, Buttons, FileCtrl, ShellApi,
  aboutunit, math;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    GroupBox1: TGroupBox;
    optAllFiles: TCheckBox;
    Label5: TLabel;
    dirNames: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    optIncDirs: TCheckBox;
    status: TStatusBar;
    Image1: TImage;
    AddDirs: TSpeedButton;
    cmdSearch: TSpeedButton;
    Label12: TLabel;
    Label2: TLabel;
    timHours: TLabel;
    Label4: TLabel;
    results: TListView;
    timMins: TLabel;
    timSecs: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Timer1: TTimer;
    Label3: TLabel;
    optFormatCab: TCheckBox;
    optFormatZip: TCheckBox;
    Savedlg: TSaveDialog;
    SpeedButton1: TSpeedButton;
    optFormatArj: TCheckBox;
    SpeedButton2: TSpeedButton;
    optFormatRar: TCheckBox;
    optFormatZoo: TCheckBox;
    optFormatLzh: TCheckBox;
    Bevel1: TBevel;
    optFormatTar: TCheckBox;
    optFormatAce: TCheckBox;
    optFormatArc: TCheckBox;
    fileNames: TEdit;
    procedure AddDirsClick(Sender: TObject);
    procedure cmdSearchClick(Sender: TObject);
    procedure fileNamesKeyPress(Sender: TObject; var Key: Char);
    procedure dirNamesKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure resultsColumnClick(Sender: TObject; Column: TListColumn);
    procedure resultsData(Sender: TObject; Item: TListItem);
    procedure resultsDataFind(Sender: TObject; Find: TItemFind;
      const FindString: String; const FindPosition: TPoint;
      FindData: Pointer; StartIndex: Integer; Direction: TSearchDirection;
      Wrap: Boolean; var Index: Integer);
    procedure resultsDataHint(Sender: TObject; StartIndex,
      EndIndex: Integer);
    procedure optAllFilesKeyPress(Sender: TObject; var Key: Char);
    procedure optIncDirsKeyPress(Sender: TObject; var Key: Char);
    procedure optMaxKeyPress(Sender: TObject; var Key: Char);
    procedure optAttrHiddenKeyPress(Sender: TObject; var Key: Char);
    procedure optAttrReadOnlyKeyPress(Sender: TObject; var Key: Char);
    procedure optAttrSystemFileKeyPress(Sender: TObject; var Key: Char);
    procedure optAttrDirectoryKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure resultsDblClick(Sender: TObject);
    procedure resultsKeyPress(Sender: TObject; var Key: Char);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure resultsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure FormShow(Sender: TObject);
    procedure WMMouseMove( var msg:TMessage ); message WM_MOUSEMOVE;
  private
    { Private declarations }
    mousemsg:TMessage;
    curHintColor:TColor;
    hintColors: Array[1..14] of TColor;
  public
    { Public declarations }
    fileList : TList;
    reverseSort1, reverseSort2, reverseSort3 : boolean;
    procedure ClearTheList;
    procedure reverseList;
  end;

  TSearchThread = class(TThread)
  public
  procedure Execute; override;
  end;

  ItemData = record
  	Caption, Subitem1, Subitem2 : string;
  end;
var
  Form1: TForm1;
  lastTime: boolean;
  searchStarted : boolean;
  searchThread : TSearchThread;
  selectedColumn : string;
  {For saving results}
  dirsSearched:string;
  searchWildCards:string;
implementation

{$R *.DFM}

{ Popup the 'select directory' box' }
procedure TForm1.AddDirsClick(Sender: TObject);
var
   bi: TBROWSEINFO;
   selDir : array[0..1023] of char;
   title: PChar;
   res: PItemIDList;
begin
     GetMem(title,100);
     strpcopy(title,'Choose a folder, the archives in the subdirectories of ' +
                    'which will be searched for files:');

     bi.hwndOwner := form1.handle;
     bi.pidlRoot := nil;
     bi.pszDisplayName := @selDir;
     bi.lpszTitle := title;
     bi.ulFlags := BIF_RETURNONLYFSDIRS;
     bi.lpfn := nil;
     res := SHBrowseForFolder(bi);

     if( res <> nil ) then
     begin
         ShGetPathFromIDList(res,bi.pszDisplayName);

         if dirNames.Text <> '' then
            dirNames.Text := dirNames.Text + ';' + bi.pszDisplayName
         else
            dirNames.Text := bi.pszDisplayName;
     end;

     freemem(title,1024);
end;

{ Separate a string by ';' into sub strings with some additional manipulation }
function GetStrings( s: string ): TStringList;
var
   retStr : TStringList;
   t : integer;
   startPos : integer;
   notBlank : boolean;
begin
     retStr := TStringList.Create;
     retStr.Duplicates := dupIgnore;
     notBlank := false;
     startPos := 1;

     for t := 1 to length(s) do
     begin
          if s[t] = ';' then
          begin
             retStr.Add( Copy(s,startPos,(t-startPos)) );
             startPos := t+1;
          end;
          notBlank := true;
     end;
     if notBlank then
        retStr.Add( Copy(s,startPos,(t-startPos)) );

     // Delete empty names
     for t := retStr.count-1 downto 0 do
     begin
          if retStr.strings[t] = '' then
             retStr.Delete(t);
     end;

     // Remove '\' in all names if necessary
     for t := 0 to retStr.count-1 do
     begin
          if( retStr.strings[t][length(retStr.strings[t])] = '\' ) then
          begin
          	if ( retStr.strings[t] <> '\' ) then
              		retStr.strings[t] := Copy(retStr.strings[t],1,length(retStr.strings[t])-1)
                else
                	retStr.strings[t] := 'C:';
          end;
     end;
     result := retStr;
end;

{ Check if a file name is already added to the listbbox }
function NotADuplicate( str1, str2: string ): boolean;
var
	t : integer;
        i : ^ItemData;
begin
	NotADuplicate := true;

	for t := 0 to form1.fileList.Count-1 do
        begin
        	i := form1.fileList.Items[t];
                if( i^.Caption = str1 ) then
                	if( i^.subitem2 = str2 ) then
                        begin
                        	NotADuplicate := false;
                                exit;
                        end;
        end;
end;

{ Convert integer file size to a short string representation with appended units }
function GetFileSiz( fs : integer ): string;
var
	fSize : string;
begin
	fSize := ' b';

        if (fs div 1024) > 0 then
        begin
        	fSize := ' Kb';
                fs := fs div 1024;
        end;

        if (fs div 1024) > 0 then
        begin
        	fSize := ' Mb';
                fs := fs div 1024;
        end;
        if (fs div 1024) > 0 then
        begin
        	fSize := ' Gb';
                fs := fs div 1024;
        end;

        fSize := inttostr(fs) + fSize;
        GetFileSiz := fSize;
end;

{ Octal # to a decimal # }
function OctToDec(d:integer):integer;
var
    x,sum:integer;
begin
    x := 0; sum := 0;

    while( d > 0 ) do
    begin
    	if( x = 0 ) then
	        sum := sum + (d mod 10)
        else
	        sum := sum + (d mod 10) * round(power(8,x));
        d := d div 10;
        inc(x);
    end;

    result := sum;
end;

{ Convert '/' in path to '\' as stored in some archive formats }
{ Only included for uniformity in display }
procedure ConvertUnixPathtoDosPath( var path:string );
var
	t:integer;
begin
	for t := 1 to length(path) do
        	if( path[t] = '/' ) then path[t] := '\';
end;

{ Add files from a ZIP archive to the listbox }
{ ZIP is the most popular archive format }
procedure AddFilesInZip( archiveName,pattern: string);
type
	Header = packed record
	    	sig : array[0..3] of char;
            	version : word;
    		genp : word;
    		method : word;
    		fileDate : dword;
                crc : dword;
    		compressedSize : dword;
                unCompressedSize : dword;
    		filenameLen : word;
    		extrafieldLen : word;
         end;
var
	hdr : Header;
        inf : integer;
        res : integer;
        fileName : string;
        tmpName : string;
        c : char;
        fileSize : string;
        itm : ^ItemData;
label __ignoreAdd;

begin
	if( not form1.optFormatZip.checked ) then
        	exit;

	fileName := '';

	inf := FileOpen(archiveName, fmOpenRead or fmShareDenyNone );

        if( inf = -1 ) then exit;

        while(true) do
        begin
        	res := FileRead(inf,hdr,sizeof(hdr));

                if( res < sizeof(hdr) ) then
                	break;

		if  (hdr.sig[0] <> 'P') or
                    (hdr.sig[1] <> 'K') or
		    (hdr.sig[2] <> chr(3)) or
		    (hdr.sig[3] <> chr(4))
			then
	            break;

            	if( hdr.unCompressedSize > 1000*1000 ) then
                	fileSize := inttostr(hdr.unCompressedSize div (1000*1000) ) + ' Mb'
                else if( hdr.unCompressedSize > 1000 ) then
                	fileSize := inttostr(hdr.unCompressedSize div 1000) + ' Kb'
                else
                	fileSize := inttostr(hdr.unCompressedSize) + ' b';

		tmpName := '';

	        while( hdr.filenameLen > 0 ) do
        	begin
        		dec(hdr.filenameLen);
		        res := FileRead(inf,c,1);

                        if( res = 0 ) then break;

                        tmpName := tmpName + c;
	        end;

                ConvertUnixPathtoDosPath(tmpName);

                if (not form1.optIncDirs.checked) and
                   (tmpName[length(tmpname)] = '/') then goto __ignoreAdd;

               	if( MatchesMask( LowerCase(tmpName), LowerCase(pattern) ) ) then
                begin
                       	New(itm);
                        itm^.Caption := tmpName;
                        if tmpName[length(tmpname)] = '\' then
	                        itm^.Subitem1 := '[dir]'
                        else
	                        itm^.Subitem1 := fileSize;

                        itm^.subitem2 := archiveName;
                      	if NotADuplicate(itm^.caption,itm^.SubItem2) then
                       		form1.fileList.Add(itm)
                       	else
                               	Dispose(itm);
                        form1.results.Items.Count := form1.fileList.Count;
                end;

                __ignoreAdd:

	        FileSeek(inf, hdr.extrafieldLen + hdr.compressedSize, 1);
        end;

        FileClose(inf);
end;

{ Add files from a CAB archive to the listbox }
{ This is Microsoft CAB Format that is used in MS products
  like Internet Explorer, Win 9x and what not?. If you
  find a system file missing (like wsock32.dll or explorer.exe)
  just find them inside these Win 9x cab files with this tool}
procedure AddFilesInCab( archiveName,pattern: string );
var
	tmpW:integer;
        noFiles:word;
	c:char;
	fileSiz:integer;
	fileSizeStr:string;
	fileName:string;
	fin:integer;
	itm : ^ItemData;
begin
	if( not form1.optFormatCab.checked ) then
        	exit;

	fileSizeStr := '';
	fin := FileOpen(archiveName, fmOpenRead or fmShareDenyNone );

	if( fin = -1 ) then exit;

	{ File Signature check }
	FileRead(fin,tmpW,4);
	if( tmpW <>  1178817357 ) then
	begin
		FileClose(fin);
	        exit;
	end;

	FileSeek(fin,16,0);
	FileRead(fin,tmpW,4);
	FileSeek(fin,8,1);
	FileRead(fin,noFiles,2);
	FileSeek(fin,tmpW,0);

	while( noFiles > 0 ) do
	begin
	        FileRead(fin,fileSiz,4);

        	if( fileSiz > (1000*1000) ) then
                	fileSizeStr := inttostr(fileSiz div (1000*1000)) + ' Mb'
        	else if( fileSiz > 1000 ) then
            		fileSizeStr := inttostr(fileSiz div 1000) + ' Kb'
                else
            		fileSizeStr := inttostr(fileSiz) + ' b';

        	FileSeek(fin,12,1);

		fileName := '';
	        while( true ) do
        	begin
        		if( FileRead(fin,c,1) = 0 ) then break;
	                if( c = #0) then break;
        	        fileName := fileName + c;
	        end;

                ConvertUnixPathtoDosPath(fileName);

	        if( MatchesMask( LowerCase(fileName), LowerCase(pattern)) ) then
        	begin
        		New(itm);
	                itm^.Caption := fileName;
        	        itm^.Subitem1 := fileSizeStr;
                	itm^.Subitem2 := archiveName;
			if NotADuplicate(itm^.caption,itm^.SubItem2) then
				form1.fileList.Add(itm)
	                else
				Dispose(itm);
			form1.results.Items.Count := form1.fileList.Count;
	        end;
	        dec(noFiles);
	end;
	FileClose(fin);
end;

{ Add files from a Rar archive to the listbox }
{ Rar is quite popular and offers very good compression }
procedure AddFilesInRar( archiveName,pattern: string );
var
    fileSig: array[0..7] of byte;
    tmpW:word;
    tmpB:byte;
    headerSize,flags:word;
    blockSize:dword;
    fileSize:dword;
    fileSizeStr:string;
    startPos:integer;
    c:char;
    fin:integer;
    tmpName:string;
    itm: ^ItemData;
label __ignoreAdd;
begin
    if( not form1.optFormatRar.checked ) then
       	exit;

    fin := FileOpen(archiveName,  fmOpenRead or fmShareDenyNone );

    if(fin = -1) then exit;

    FileRead(fin,fileSig,7);

    if( (fileSig[0] <> $52) or
        (fileSig[1] <> $61) or
        (fileSig[2] <> $72) or
        (fileSig[3] <> $21) or
        (fileSig[4] <> $1A) or
        (fileSig[5] <> $07) or
        (fileSig[6] <> $00) ) then
    begin
        FileClose(fin);
        exit;
    end;

    while(true)do
    begin
        startPos := FileSeek(fin,0,1);
        FileSeek(fin,2,1);
        if( FileRead(fin,tmpB,1) = 0 ) then break;

        if( tmpB = $74 ) then
        begin
            if( FileRead(fin,flags,2) < 2 ) then break;
            if( FileRead(fin,headerSize,2) < 2 ) then break;
            if( FileRead(fin,blockSize,4) < 4 ) then break;
            if( FileRead(fin,fileSize,4) < 4 ) then break;
            FileSeek(fin,11,1);
            if( FileRead(fin,tmpW,2) < 2 ) then break;
            FileSeek(fin,4,1);

            if( tmpW <> 0 ) then
            begin
                if( fileSize > (1000*1000) ) then
                    fileSizeStr := inttostr(fileSize div (1000*1000)) + ' Mb'
                else if( fileSize > 1000 ) then
                    fileSizeStr := inttostr(fileSize div 1000) + ' Kb'
                else
                    fileSizeStr := inttostr(fileSize) + ' b'
            end;

            if( tmpW = 0 ) then break;

            tmpName := '';
            while( tmpW > 0 ) do
            begin
            	if( FileRead(fin,c,1) < 1 ) then break;
                tmpName := tmpName + c;
                dec(tmpW);
            end;

            if (not form1.optIncDirs.checked) and
                ((flags and 224)=224) then goto __ignoreAdd;

	    ConvertUnixPathtoDosPath(tmpName);

            if( MatchesMask( LowerCase(tmpName), LowerCase(pattern)) ) then
            begin
            	New(itm);
	        itm^.Caption := tmpName;
                if(flags and 224)=224 then
	                itm^.Subitem1 := '[dir]'
                else
	                itm^.Subitem1 := fileSizeStr;
              	itm^.Subitem2 := archiveName;
	    	if NotADuplicate(itm^.caption,itm^.SubItem2) then
	    		form1.fileList.Add(itm)
	        else
	    		Dispose(itm);
	    	form1.results.Items.Count := form1.fileList.Count;
	    end;

            __ignoreAdd:

            FileSeek(fin,startPos+headerSize+blockSize,0);
        end
        else if( tmpB = $77 ) then
        begin
            FileSeek(fin,2,1);
            if( FileRead(fin,headerSize,2) < 2 ) then break;
            if( FileRead(fin,blockSize,4) < 4 ) then break;
            FileSeek(fin,startPos+headerSize+blockSize,0);
        end
        else
        begin
            FileSeek(fin,2,1);
            if( FileRead(fin,headerSize,2) < 2 ) then break;
            FileSeek(fin,startPos+headerSize,0);
        end;
    end;

    FileClose(fin);
end;

{ Add files from a ACE archive to the listbox }
{ ACE is a new format that offers good compression and features }
procedure AddFilesInAce( archiveName,pattern: string );
var
    fileSize, blockSize:dword;
    fileSizeStr:string;
    tmpW, fileAttr:word;
    tmpW2:smallint;
    tmpName:string;
    tmpB:byte;
    sig:array[1..8] of char;
    startPos:integer;
    c:char;
    fin:integer;
    itm:^itemData;
label __ignoreAddAceFile;
begin

    if( not form1.optFormatAce.checked ) then
       	exit;

    fin := FileOpen(archiveName,  fmOpenRead or fmShareDenyNone );

    if(fin = -1) then exit;

    FileSeek(fin,2,0);
    FileRead(fin,tmpW,2);
    FileSeek(fin,3,1);
    FileRead(fin,sig,7);
    sig[8] := #0;

    if( strcomp(@sig,PChar('**ACE**')) <> 0) then
    begin
        FileClose(fin);
        exit;
    end;

    FileSeek(fin,4+tmpW,0);

    while( true )do
    begin
        startPos := FileSeek(fin,0,1);
        FileSeek(fin,2,1);
        if( FileRead(fin,tmpW,2) < 2 ) then break;
        if( FIleRead(fin,tmpB,1) = 0 ) then break;

        FileSeek(fin,2,1);

        FileRead(fin,blockSize,4);
        FileRead(fin,fileSize,4);
        FileSeek(fin,4,1);
        FileRead(fin,fileAttr,2);
        FileSeek(fin,12,1);
        FileRead(fin,tmpW2,2);

        if( tmpW2 = -1 ) then break;

        if( fileSize > (1000*1000) ) then
              fileSizeStr := inttostr(fileSize div (1000*1000)) + ' Mb'
        else if( fileSize > 1000 ) then
              fileSizeStr := inttostr(fileSize div 1000) + ' Kb'
        else
              fileSizeStr := inttostr(fileSize) + ' b';

	tmpName := '';
        while( tmpW2 > 0 ) do
        begin
            if( FileRead(fin,c,1) = 0 ) then
            begin
            	FileClose(fin);
                exit;
            end;

            tmpName := tmpName + c;
            dec(tmpW2);
        end;

        if (not form1.optIncDirs.checked) and
            ((fileAttr and $10) > 0) then goto __ignoreAddAceFile;

       	ConvertUnixPathtoDosPath(tmpName);

        if( MatchesMask( LowerCase(tmpName), LowerCase(pattern)) ) then
        begin
        	New(itm);
	        itm^.Caption := tmpName;
                if ((fileAttr and $10) > 0) then
	                itm^.Subitem1 := '[dir]'
                else
	                itm^.Subitem1 := fileSizeStr;
              	itm^.Subitem2 := archiveName;
	    	if NotADuplicate(itm^.caption,itm^.SubItem2) then
	    		form1.fileList.Add(itm)
	        else
	    		Dispose(itm);
	    	form1.results.Items.Count := form1.fileList.Count;
 	end;

        __ignoreAddAceFile:

        FileSeek(fin, 4 + startPos + tmpW + blockSize, 0);
    end;

    FileClose(fin);
end;

{ Add files from a TAR archive to the listbox }
{ The old boring Tar format widely used for backup purpose
  and which offers *no* compression! }
procedure AddFilesInTar( archiveName,pattern: string );
type
	TarHeader = record
	        name: array[1..100] of char;
        	mode: array[1..8] of char;
	        uid: array[1..8] of char;
        	gid: array[1..8] of char;
	        size: array[1..12] of char;
        	mtime: array[1..12] of char;
	        chksum: array[1..8] of char;
        	linkflag: char;
	        linkname: array[1..100] of char;
        	magic: array[1..8] of char;
	        uname: array[1..32] of char;
        	gname: array[1..32] of char;
	        devmajor: array[1..8] of char;
        	devminor: array[1..8] of char;
                pad:array[1..167] of char;
        end;
var
    hdr:TarHeader;
    fileSiz:integer;
    tmpName:string;
    c:char;
    fileSizeStr:string;
    fin,tmpVar, tmpPos:integer;
    itm:^itemData;
label __ignoreTarAdd;
begin
    if( not form1.optFormatTar.checked ) then
       	exit;

    fileSizeStr := '';

    fin:= FileOpen( archiveName, fmOpenRead or fmShareDenyNone );

    if(fin = -1) then  exit;

    while(true)do
    begin
	if( FileRead(fin,hdr,sizeof(hdr)) < sizeof(hdr) ) then break;
	hdr.size[12] := #0;

        if  (strcomp( @hdr.magic,PChar('ustar  '))=0) then
        begin
	    fileSiz := OctToDec( strtoint(strpas(@hdr.size)) );

            if( fileSiz > (1000*1000) ) then
                fileSizeStr := inttostr(fileSiz div (1000*1000)) + ' Mb'
            else if( fileSiz > 1000 ) then
                fileSizeStr := inttostr(fileSiz div 1000) + ' Kb'
            else
                fileSizeStr := inttostr(fileSiz) + ' b';

            if (hdr.linkflag = '5') and
               (not form1.optIncDirs.checked ) then
               	goto __ignoreTarAdd;

            tmpName := strpas(@hdr.name);
            ConvertUnixPathtoDosPath(tmpName);

	    if( MatchesMask( LowerCase(tmpName), LowerCase(pattern)) ) then
            begin
        	New(itm);
	        itm^.Caption := tmpName;
                itm^.Subitem1 := fileSizeStr;
              	itm^.Subitem2 := archiveName;
	    	if NotADuplicate(itm^.caption,itm^.SubItem2) then
	    		form1.fileList.Add(itm)
	        else
	    		Dispose(itm);
	    	form1.results.Items.Count := form1.fileList.Count;
            end;
            __ignoreTarAdd:
        end
        else
        	break;

	tmpVar := 0;
	tmpPos := FileSeek(fin,OctToDec( strtoint(strpas(@hdr.size))),1);
        while( true )do
        begin
            if( FileRead(fin,c,1) = 0 ) then
            begin
            	FileClose(fin);
                exit;
            end;
            if( c <> #0 ) then break;
            inc(tmpVar);
        end;

        FileSeek(fin,tmpPos+tmpVar,0);
    end;

    FileClose(fin);
end;

{ Add files from a ZIP archive to the listbox }
{ Arc is a vry old compression format }
procedure AddFilesInArc( archiveName,pattern: string );
var
    fileSiz, blockSize:dword;
    fileSizeStr:string;
    tmpW:word;
    tmpB:byte;
    fileName:array[1..13] of char;
    tmpName:string;
    fin : integer;
    itm:^itemData;
begin
    if( not form1.optFormatArc.checked ) then
       	exit;

    fin := FileOpen(archiveName, fmOpenRead or fmShareDenyNone);

    if(fin = -1) then exit;

    FileRead(fin,tmpB,1);

    if( tmpB <> $1A ) then
    begin
        FileClose(fin);
        exit;
    end;

    FileRead(fin,tmpW,2);

    if( (tmpW = $5048 ) or (tmpW = $5453) ) then
    begin
        FileClose(fin);
        exit;
    end;

    FileSeek(fin,0,0);

    while( true ) do
    begin
        FileRead(fin,tmpB,1);
        if( tmpB <> $1A ) then break;

        FileRead(fin,tmpB,1);
        if( tmpB = 0 ) then break;

        FileRead(fin,fileName,13);

        FileRead(fin,blockSize,4);

        FileSeek(fin,6,1);

        FileRead(fin,fileSiz,4);

        if( fileSiz > (1000*1000) ) then
            fileSizeStr := inttostr(fileSiz div (1000*1000)) + ' Mb'
        else if( fileSiz > 1000 ) then
            fileSizeStr := inttostr(fileSiz div 1000) + ' Kb'
        else
            fileSizeStr := inttostr(fileSiz) + ' b';

        tmpName := strpas(@fileName);
        ConvertUnixPathtoDosPath(tmpName);

	if( MatchesMask( LowerCase(tmpName), LowerCase(pattern)) ) then
        begin
        	New(itm);
	        itm^.Caption := tmpName;
                itm^.Subitem1 := fileSizeStr;
              	itm^.Subitem2 := archiveName;
	    	if NotADuplicate(itm^.caption,itm^.SubItem2) then
	    		form1.fileList.Add(itm)
	        else
	    		Dispose(itm);
	    	form1.results.Items.Count := form1.fileList.Count;
        end;

        FileSeek(fin,blockSize,1);
    end;

    FileClose(fin);
end;

{ Add files from a ZIP archive to the listbox }
{ Same Algorithm as Zip and used widely "inside" some applications
  rather than as a format }
procedure AddFilesInLzh( archiveName,pattern: string );
var
    tmpDW:dword;
    fileSize:dword;
    tmpB:byte;
    sig:array[0..2]of char;
    startPos:integer;
    c:char;
    fin:integer;
    tmpName:string;
    fileSizeStr:string;
    itm:^ItemData;
begin
    if( not form1.optFormatLzh.checked ) then
        	exit;

    fin := FileOpen( archiveName, fmOpenRead or fmShareDenyNone);

    if(fin = -1) then exit;

    while(true)do
    begin
        startPos := FileSeek(fin,0,1);
        FileRead(fin,tmpB,1);
        FileSeek(fin,1,1);
        FileRead(fin,sig,3);

        if( (sig[0] <> '-') or (sig[1] <> 'l') or
            ((sig[2] <> 'z') and (sig[2] <> 'h')) ) then
            break;

        FileSeek(fin,2,1);
        FileRead(fin,tmpDW,4);
        inc(tmpDW,tmpB);
        FileRead(fin,fileSize,4);
        FileSeek(fin,6,1);
        FileRead(fin,tmpB,1);

        if( tmpB = 0 ) then break;

        if( fileSize > (1000*1000) ) then
            fileSizeStr := inttostr(fileSize div (1000*1000)) + ' Mb'
        else if( fileSize > 1000 ) then
            fileSizeStr := inttostr(fileSize div 1000) + ' Kb'
        else
            fileSizeStr := inttostr(fileSize) + ' b';

	tmpName := '';
        while( tmpB > 0 ) do
        begin
            if( FileRead(fin,c,1) = 0 ) then break;
            tmpName := tmpName + c;
            dec(tmpB);
	end;

        ConvertUnixPathtoDosPath(tmpName);

        if( MatchesMask( LowerCase(tmpName), LowerCase(pattern)) ) then
        begin
        	New(itm);
	        itm^.Caption := tmpName;
                itm^.Subitem1 := fileSizeStr;
              	itm^.Subitem2 := archiveName;
	    	if NotADuplicate(itm^.caption,itm^.SubItem2) then
	    		form1.fileList.Add(itm)
	        else
	    		Dispose(itm);
	    	form1.results.Items.Count := form1.fileList.Count;
        end;

        FileSeek(fin, startPos + tmpDW + 2,0);
    end;

    FileClose(fin);
end;

{ Add files from a ZIP archive to the listbox }
{ One more popular compression format }
procedure AddFilesInArj( archiveName,pattern: string );
var
    tmpDW, fileSize:dword;
    fileSizeStr:string;
    fileName:string;
    tmpW:word;
    tmpB:byte;
    extraField:boolean;
    c:char;
    startPos:integer;
    fin:integer;
    itm : ^itemData;
begin

    if( not form1.optFormatArj.checked ) then
        	exit;

    extraField := false;

    fin := FileOpen(archiveName, fmOpenRead or fmShareDenyNone );

    if(fin = -1) then exit;

    FileSeek(fin,0,0);
    FileRead(fin,tmpW,2);

    if( tmpW <> 60000 ) then
    begin
        FileClose(fin);
        exit;
    end;

    FileRead(fin,tmpW,2);

    startPos := FileSeek(fin,tmpW+10,0);

    while(true)do
    begin
        FileRead(fin,tmpW,2);
        if( tmpW <> 60000 ) then break;
        FileRead(fin,tmpW,2);  { Header size }
        if( tmpW = 0 ) then break;

        FileSeek(fin,4,1);
        FileRead(fin,tmpB,1);  { Archive attributes }

        if( (tmpB and $8)<>0 ) then
            extraField := true;

        FileSeek(fin,7,1);
        FileRead(fin,tmpDW,4); { Compressed file size for skipping purpose }
        FileRead(fin,fileSize,4);

        if( extraField ) then
	        FileSeek(fin, 14,1)
        else
	        FileSeek(fin, 10,1);

       	if( fileSize > (1000*1000) ) then
               	fileSizeStr := inttostr(fileSize div (1000*1000)) + ' Mb'
       	else if( fileSize > 1000 ) then
       		fileSizeStr := inttostr(fileSize div 1000) + ' Kb'
        else
      		fileSizeStr := inttostr(fileSize) + ' b';

        fileName := '';
        while(true)do
        begin
            if( FileRead(fin,c,1) = 0 ) then break;
            if( c = #0 ) then break;
            fileName := fileName + c;
        end;

        ConvertUnixPathtoDosPath(fileName);

        if( MatchesMask( LowerCase(fileName), LowerCase(pattern) ) ) then
       	begin
       		New(itm);
                itm^.Caption := fileName;
       	        itm^.Subitem1 := fileSizeStr;
               	itm^.Subitem2 := archiveName;
		if NotADuplicate(itm^.caption,itm^.SubItem2) then
			form1.fileList.Add(itm)
                else
			Dispose(itm);
		form1.results.Items.Count := form1.fileList.Count;
        end;

        startPos := FileSeek(fin,startPos+tmpW+10+tmpDW,0);
    end;

    FileClose(fin);
end;

{ Add files from a ZIP archive to the listbox }
{ Format Sometimes used on the usenet }
procedure AddFilesInZoo( archiveName,pattern: string );
var
    tmpDW:dword;
    fileSize:dword;
    c:char;
    fin:integer;
    fileSizeStr:string;
    tmpName:string;
    itm:^ItemData;
begin
    if( not form1.optFormatZoo.checked ) then
        	exit;

    fin := FileOpen( archiveName, fmOpenRead or fmShareDenyNone );

    if(fin = -1) then exit;

    FileSeek(fin,20,0);
    FileRead(fin,tmpDW,4);

    if( tmpDW <> $FDC4A7DC ) then
    begin
        FileClose(fin);
        exit;
    end;

    FileRead(fin,tmpDW,4);
    FileSeek(fin,tmpDW,0);

    while( true ) do
    begin
        FileRead(fin,tmpDW,4);

        if( tmpDW <> $FDC4A7DC ) then  break;

        FileSeek(fin,2,1);
        FileRead(fin,tmpDW,4);
        FileSeek(fin,10,1);
        FileRead(fin,fileSize,4);
        FileSeek(fin,14,1);


        if( fileSize > (1000*1000) ) then
            fileSizeStr := inttostr(fileSize div (1000*1000)) + ' Mb'
        else if( fileSize > 1000 ) then
            fileSizeStr := inttostr(fileSize div 1000) + ' Kb'
        else
            fileSizeStr := inttostr(fileSize) + ' b';

        tmpName := '';
        while(true) do
        begin
		if( FileRead(fin,c,1) = 0 ) then
                begin
	                FileClose(fin);
        	        exit;
                end;
        	if( (c = #31) or (c = #0) ) then break;
        	tmpName := tmpName + c;
        end;

        ConvertUnixPathtoDosPath(tmpName);

        if( length(tmpName) <> 0 ) and
          ( MatchesMask( LowerCase(tmpName), LowerCase(pattern) ) ) then
	begin
		New(itm);
                itm^.Caption := tmpName;
 	        itm^.Subitem1 := fileSizeStr;
       		itm^.Subitem2 := archiveName;
		if NotADuplicate(itm^.caption,itm^.SubItem2) then
			form1.fileList.Add(itm)
	        else
			Dispose(itm);
		form1.results.Items.Count := form1.fileList.Count;
        end;

        FileSeek(fin,tmpDW,0);
    end;

    FileClose(fin);
end;
{------------------------------------------------------------}

{ Automatically detect archive type by file extension and list it by
wildcards into the listbox }
procedure AddFilesInArchive( archiveName,fileNames: string );
var
	t : integer;
        fils : TStringList;
        ext : string;
        AddFilesInMainArchive : procedure(archiveName,pattern:string);
begin

        fils := GetStrings(fileNames);

        if( length(archiveName) > 4 ) then
	        ext := LowerCase(Copy(archiveName, length(archiveName)-3,4))
        else
        	exit;

        if( ext = '.zip') then
        	AddFilesInMainArchive := @AddFilesInZip
	else
        if( ext = '.cab') then
        	AddFilesInMainArchive := @AddFilesInCab
        else
        if( ext = '.zoo') then
        	AddFilesInMainArchive := @AddFilesInZoo
        else
        if( ext = '.arj') then
        	AddFilesInMainArchive := @AddFilesInArj
        else
        if( ext = '.arc') then
        	AddFilesInMainArchive := @AddFilesInArc
        else
        if( ext = '.rar') then
        	AddFilesInMainArchive := @AddFilesInRar
        else
        if( ext = '.tar') then
        	AddFilesInMainArchive := @AddFilesInTar
        else
        if( ext = '.ace') then
        	AddFilesInMainArchive := @AddFilesInAce
        else
        if( ext = '.lzh') then
        	AddFilesInMainArchive := @AddFilesInLzh;

        for t := 0 to fils.Count-1 do
        begin
        	if(fils.Strings[t] <> '*.*') then
	        	AddFilesInMainArchive(archiveName,fils.Strings[t])
                else
	        	AddFilesInMainArchive(archiveName,'*');
        end;

end;

{ The core search routine that handles both archive and file search }
procedure GetFilesList( path: String; filter: String );
var
   f1: TSearchrec;
   fils : TStringList;
   t : integer;
   itm : ^ItemData;
   attr : integer;
   fSize : string;

label _ignoreFileSearch;

begin
     fils := GetStrings(filter);

     if( length(path) < 28 ) then
	     form1.status.Panels.Items[1].Text := path
     else
	     form1.status.Panels.Items[1].Text := '...' + Copy(path, length(path)-27,28);

     attr := faAnyFile;

     if( not form1.optAllFiles.Checked ) then
	goto _ignoreFileSearch;

     // Normal files search
     for t := 0 to fils.Count-1 do
     begin
          if( FindFirst(path+'\'+fils.Strings[t], attr, f1) = 0 ) then
          begin
          	fSize := ' b';
          	if form1.optIncDirs.Checked and
                  (f1.name <> '.') and
                  (f1.name <> '..') then
                begin
			New(itm);
                        itm^.Caption := f1.name;

                        if( FileExists(path+'\'+f1.name) ) then
        	                itm^.subitem1 := GetFileSiz(f1.size)
                        else
                                itm^.SubItem1 := '[dir]';

                        itm^.SubItem2 := path;

                        if NotADuplicate(itm^.caption,itm^.SubItem2) then
                        	form1.fileList.Add(itm)
                        else
                                Dispose(itm);

			form1.results.Items.Count := form1.fileList.Count;
                end
                else
                begin
          		if( FileExists(path+'\'+f1.name) ) then
                	begin
                		New(itm);
                		itm^.caption := f1.name ;
                                itm^.SubItem1 := GetFileSiz(f1.size);
                        	itm^.SubItem2 := path;

                        	if NotADuplicate(itm^.caption,itm^.SubItem2) then
                        		form1.fileList.Add(itm)
                        	else
                                	Dispose(itm);
				form1.results.Items.Count := form1.fileList.Count;
                	end;
                end;

                while( FindNext(f1) = 0 ) do
                begin
                	fSize := ' b';
          		if form1.optIncDirs.Checked and (f1.name <> '.') and (f1.name <> '..')then
                	begin
                		New(itm);
                		itm^.Caption := f1.name;
                        	if( FileExists(path+'\'+f1.name) ) then
                                        itm^.Subitem1 := GetFileSiz(f1.size)
                        	else
                                        itm^.Subitem1 := '[dir]' ;

                        	itm^.SubItem2 := path;

                        	if NotADuplicate(itm^.caption,itm^.SubItem2)then
                        		form1.fileList.Add(itm)
                        	else
                                	Dispose(itm);
				form1.results.Items.Count := form1.fileList.Count;
                	end
                	else
                	begin
          			if( FileExists(path+'\'+f1.name) ) then
                		begin
                			New(itm);
                			itm^.caption := f1.name ;
                			itm^.subitem1 := GetFileSiz(f1.size);
                        		itm^.SubItem2 := path ;

                        		if NotADuplicate(itm^.caption,itm^.SubItem2) then
                        			form1.fileList.Add(itm)
                        		else
                                		Dispose(itm);
					form1.results.Items.Count := form1.fileList.Count;
                		end;
                	end;
                end;
          end;
     end;

_ignoreFileSearch:
     { Search of Archives }

     fils := GetStrings('*.zip;*.cab;*.arj;*.rar;*.zoo;*.lzh;*.tar;*.ace;*.arc');
     for t := 0 to fils.Count-1 do
     begin
	if( FindFirst(path + '\' + fils.Strings[t], attr, f1) = 0 ) then
     	begin
     		if( not DirectoryExists(path + '\' + f1.name)) then
       	        	AddFilesInArchive(path + '\' + f1.name, filter);

	        while( FindNext(f1) = 0 ) do
	        begin
	     		if( not DirectoryExists(path + '\' + f1.name)) then
	                        AddFilesInArchive(path + '\' + f1.name, filter);
           	end;
     	end;
     end;

     attr := faDirectory;
     // Scan sub-directories recursively
     if( FindFirst(path+'\*', attr, f1) = 0 ) then
     begin
     	   if( DirectoryExists(path+'\'+f1.name) and (f1.name <> '.') and (f1.name <> '..') ) then
           	GetFilesList(path+'\'+f1.name, filter);

           while( FindNext(f1) = 0 ) do
           begin
           	if( DirectoryExists(path+'\'+f1.name) and (f1.name <> '.') and (f1.name <> '..') ) then
                     GetFilesList(path+'\'+f1.name, filter);
           end;
     end;
end;

{ Starts a search thread }
procedure TsearchThread.Execute;
var
   dNames : TStringList;
        t : integer;
   filter : string;
dirsNotFound : String;
begin
   form1.timHours.Caption := '00';
   form1.timSecs.Caption := '00';
   form1.timMins.Caption := '00';
   form1.timer1.Enabled := true;

   form1.status.Panels.Items[0].Text := 'Status: ';
   form1.status.Panels.Items[1].Text := 'Attempting to start search...';
   form1.ClearTheList;
   form1.results.Repaint;

   form1.status.Panels.Items[0].Text := 'Searching Directory: ';
   dNames := GetStrings(form1.dirNames.Text);
   dirsNotFound := '';
   filter := form1.fileNames.Text;
   if filter = '' then filter := '*.*';

   for t := 0 to dNames.Count-1 do
   begin
        if DirectoryExists(dNames.Strings[t]) then
   		GetFilesList(dNames.Strings[t],filter)
        else
        	dirsNotFound := dirsNotFound + dNames.Strings[t] + chr(10) + chr(13);
   end;

   form1.results.Items.Count := form1.fileList.Count;
   form1.results.Repaint;

   // Enable all the controls
   form1.fileNames.Color := clWindow;
   form1.dirNames.Color := clWindow;
   form1.fileNames.Enabled := true;
   form1.dirNames.enabled := true;
   form1.optAllFiles.Enabled := true;
   form1.optIncDirs.Enabled := true;
   form1.optFormatCab.Enabled := true;
   form1.optFormatZip.Enabled := true;
   form1.optFormatArj.Enabled := true;
   form1.optFormatRar.Enabled := true;
   form1.optFormatZoo.Enabled := true;
   form1.optFormatLzh.Enabled := true;
   form1.optFormatTar.Enabled := true;
   form1.optFormatAce.Enabled := true;
   form1.optFormatArc.Enabled := true;

   searchStarted := false;
   form1.cmdSearch.Caption := '&Search Now';
   form1.fileNames.SetFocus;

   form1.status.Panels.Items[0].Text  := 'Matching files found: ';
   form1.status.Panels.Items[1].Text  := inttostr(form1.results.Items.count);

   if length(dirsNotFound) <> 0 then
   begin
        MessageBox(form1.handle,
           PChar(dirsNotFound),
           'The following directories/drives do not exist:',
           MB_OK);
   end;

   try
   	dNames.Destroy;
   except
   end;
   form1.timer1.Enabled := false;
end;

{ Either start a search or stop it }
procedure TForm1.cmdSearchClick(Sender: TObject);
begin
   if dirNames.Text = '' then
   begin
   	MessageBox(form1.handle,'You need to specify the directories to want to search','Note:',MB_OK);
        exit;
   end;

   Hint := '';
   
   if searchStarted then
   begin
   	searchStarted := false;
        cmdSearch.Caption := '&Search Now';
        searchThread.Suspend;
        searchThread.Terminate;
        form1.status.Panels.Items[0].Text := 'Status: ';
	form1.status.Panels.Items[1].Text := 'Search Interrupted';
   	form1.results.Items.Count := form1.fileList.Count;
   	form1.results.Repaint;

        // Enable all the controls
        fileNames.Color := clWindow;
        dirNames.Color := clWindow;
        fileNames.Enabled := true;
        dirNames.enabled := true;
        optAllFiles.Enabled := true;
        optIncDirs.Enabled := true;
	form1.optFormatCab.Enabled := true;
	form1.optFormatZip.Enabled := true;
	form1.optFormatArj.Enabled := true;
	form1.optFormatRar.Enabled := true;
	form1.optFormatZoo.Enabled := true;
	form1.optFormatLzh.Enabled := true;
	form1.optFormatTar.Enabled := true;
	form1.optFormatAce.Enabled := true;
	form1.optFormatArc.Enabled := true;

	fileNames.SetFocus;
	form1.timer1.Enabled := false;
   end
   else
   begin
   	searchStarted := true;
        cmdSearch.Caption := '&Stop Search';
	fileNames.SetFocus;
        // Disable all the controls
        fileNames.Color := clBtnFace;
        dirNames.Color := clBtnFace;
        fileNames.Enabled := false;
        dirNames.enabled := false;
        optAllFiles.Enabled := false;
        optIncDirs.Enabled := false;
	form1.optFormatCab.Enabled := false;
	form1.optFormatZip.Enabled := false;
	form1.optFormatArj.Enabled := false;
	form1.optFormatRar.Enabled := false;
	form1.optFormatZoo.Enabled := false;
	form1.optFormatLzh.Enabled := false;
	form1.optFormatTar.Enabled := false;
	form1.optFormatAce.Enabled := false;
	form1.optFormatArc.Enabled := false;

        dirsSearched := dirNames.Text;
        searchWildCards := fileNames.text;
        searchThread := TSearchThread.Create(false);
   end;

end;

{ Helper code for user friendliness }
procedure TForm1.fileNamesKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender)
     else if (key = ':') then
        key := chr(0);
end;

{ Helper code for user friendliness }
procedure TForm1.dirNamesKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(SEnder);
end;

{ The main form initialization code. As of now it mainly creates
  a hint color array for use in the file list box }
procedure TForm1.FormCreate(Sender: TObject);
begin
     lastTime := false;
     searchStarted := false;
     fileList := TList.Create;
     Application.HintHidePause := 9000;
     randomize;

     {Initialize hintColor array}
     hintColors[1]  := RGB(190,235,254);
     hintColors[2]  := RGB(172,252,225);
     hintColors[3]  := RGB(0,249,249);
     hintColors[4]  := RGB(194,230,183);
     hintColors[5]  := RGB(222,234,142);
     hintColors[6]  := RGB(180,240,166);
     hintColors[7]  := RGB(219,176,221);
     hintColors[8]  := RGB(158,217,245);
     hintColors[9]  := RGB(251,174,196);
     hintColors[10] := RGB(226,207,182);
     hintColors[11] := RGB(197,218,220);
     hintColors[12] := RGB(221,218,172);
     hintColors[13] := RGB(213,201,233);
     hintColors[14] := RGB(221,204,198);
     Application.HintColor := hintColors[1];
end;

{ Helper code needed by Delphi for faaaaster listbox display of items }
function Compare( itm1, itm2: Pointer ): integer;
var
        item1, item2 : ^ItemData;
        tmpStr1, tmpStr2 : string;
        fSize1, fSize2 : integer;
begin
	Compare := 0;

        fSize1 := 0; fSize2 := 0; // To avoid warnings :-)

	item1 := itm1; item2 := itm2;

	if( selectedColumn = 'File Name' ) then
        begin
        	if UpperCase(item1^.Caption)  > UpperCase(item2^.caption) then
                	Compare := 1
                else if UpperCase(item1^.caption) < UpperCase(item2^.caption) then
                       	Compare := -1
                else
                      	Compare := 0;
        end;

	if( selectedColumn = 'Size' ) then
        begin
        	if (item1^.subitem1 = '[dir]') or (item2^.subitem1 = '[dir]') then
                begin
                       	if (item1^.subitem1 = '[dir]') and (item2^.subitem1 <> '[dir]') then
                       		Compare := -1
                       	else if (item1^.subitem1 <> '[dir]') and (item2^.subitem1 = '[dir]') then
                       		Compare := 1
                       	else
				Compare := 0;
                        exit;
                end;

                tmpStr1 := UpperCase(copy(item1^.subitem1,length(item1^.subitem1)-1,2));
		tmpStr2 := UpperCase(copy(item2^.subitem1,length(item2^.subitem1)-1,2));

                if (tmpStr1 = 'KB') or (tmpStr1 = 'MB') or (tmpStr1 = 'GB') then
                       	fSize1 := strtoint( Copy(item1^.SubItem1,1,length(item1^.SubItem1)-3))
                else if (tmpStr1 = ' B') then
                       	fSize1 := strtoint( Copy(item1^.SubItem1,1,length(item1^.SubItem1)-2));

                if (tmpStr2 = 'KB') or (tmpStr2 = 'MB') or (tmpStr2 = 'GB') then
                       	fSize2 := strtoint( Copy(item2^.SubItem1,1,length(item2^.SubItem1)-3))
                else if (tmpStr2 = ' B') then
                       	fSize2 := strtoint( Copy(item2^.SubItem1,1,length(item2^.SubItem1)-2));

		if tmpStr1 = 'KB' then
                       	fSize1 := fSize1 * 1024;
		if tmpStr2 = 'KB' then
                       	fSize2 := fSize2 * 1024;

                if tmpStr1 = 'MB' then
                       	fSize1 := fSize1 * 1024 * 1024;
		if tmpStr2 = 'MB' then
                       	fSize2 := fSize2 * 1024 * 1024;

		if tmpStr1 = 'GB' then
                       	fSize1 := fSize1 * 1024 * 1024 * 1024;
		if tmpStr2 = 'GB' then
                       	fSize2 := fSize2 * 1024 * 1024 * 1024;

                if fSize1 > fSize2 then
                       	Compare := 1
                else if fSize1 < fSize2 then
                       	Compare := -1
                else
                       	Compare := 0;
        end;

	if( selectedColumn = 'Path / Archive Name' ) then
        begin
        	if UpperCase(item1^.SubItem2) > UpperCase(item2^.SubItem2) then
                       	Compare := 1
                else if UpperCase(item1^.SubItem2) < UpperCase(item2^.SubItem2) then
                       	Compare := -1
                else
                       	Compare := 0;
        end;
end;

{ Sort items on column click, with some intelligence to handle
  the size field as well }
procedure TForm1.resultsColumnClick(Sender: TObject; Column: TListColumn);
begin
	if searchStarted then
        begin
        	selectedColumn := '';
        	exit;
        end;

        selectedColumn := column.Caption;
        fileList.Sort(Compare);

	if selectedColumn = 'File Name' then
        begin
                if reverseSort1 then
                	reverseList;
        	reverseSort1 := not reverseSort1;
        end;

	if selectedColumn = 'Size' then
        begin
                if reverseSort2 then
                	reverseList;
        	reverseSort2 := not reverseSort2;
        end;

	if selectedColumn = 'Path / Archive Name' then
	begin
                if reverseSort3 then
                	reverseList;
        	reverseSort3 := not reverseSort3;
        end;

        results.Repaint;
end;

{ Helper code needed by Delphi for faaaaster listbox display of items }
procedure TForm1.resultsData(Sender: TObject; Item: TListItem);
var
	li : ^ItemData;
begin
	if (item.Index > fileList.count) then exit;

        li := fileList.items[item.Index];

        Item.Caption := li^.Caption;
        Item.SubItems.Add(li^.SubItem1);
        Item.SubItems.Add(li^.SubItem2);

end;

{ Helper code needed by Delphi for faaaaster listbox display of items }
procedure TForm1.resultsDataFind(Sender: TObject; Find: TItemFind;
  const FindString: String; const FindPosition: TPoint; FindData: Pointer;
  StartIndex: Integer; Direction: TSearchDirection; Wrap: Boolean;
  var Index: Integer);
begin
//        MessageBox(form1.handle,'DataFind','',0);
	exit;
end;

{ Helper code needed by Delphi for faaaaster listbox display of items }
procedure TForm1.resultsDataHint(Sender: TObject; StartIndex,
  EndIndex: Integer);
begin
	exit;
end;

{ Of course clear the file list box }
procedure TForm1.ClearTheList;
var
	t : integer;
begin
	for t := 0 to fileList.Count-1 do
        begin
        	try
        	 Dispose(fileList.Items[t]);
                except
                 on EInvalidPointer do ;
                end;
        end;
        fileList.Clear;
        results.Items.count := fileList.Count;
end;

{ Reverse the files list }
procedure TForm1.reverseList;
var
	tmp : pointer;
        t : integer;
        hC : integer;   // Half the count
begin
	hC := fileList.Count div 2;
	for t := 0 to hC do
        begin
        	tmp := fileList.Items[t];
                fileList.Items[t] := fileList.Items[(fileList.Count-1)-t];
                fileList.Items[(fileList.Count-1)-t] := tmp;
        end;
end;

{ Helper code for user friendliness }
procedure TForm1.optAllFilesKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.optIncDirsKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.optMaxKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.optAttrHiddenKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.optAttrReadOnlyKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.optAttrSystemFileKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.optAttrDirectoryKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Helper code for user friendliness }
procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
     if (key = chr(13)) or (key = chr(10)) then
        cmdSearchClick(Sender);
end;

{ Open archive/normal files upon double click }
procedure TForm1.resultsDblClick(Sender: TObject);
var
	path : string;
        err  : integer;
        ext  : string;
begin
	if( results.Selected = nil ) then
		exit;

	ext := LowerCase(Copy(results.selected.SubItems[1],
        		length(results.selected.SubItems[1])-3,
                        4));

        if(( ext = '.zip' ) or
           ( ext = '.zoo' ) or
           ( ext = '.cab' ) or
           ( ext = '.rar' ) or
           ( ext = '.tar' ) or
           ( ext = '.ace' ) or
           ( ext = '.lzh' ) or
           ( ext = '.arc' ) or
           ( ext = '.arj' )) and
           not DirectoryExists(results.selected.SubItems[1]) then
        begin
        	path := results.selected.SubItems[1];
        end
        else
		path := results.selected.SubItems[1] +
        		'\' + results.selected.Caption;

	err := ShellExecute(form1.handle,
        	  'open', PChar(path),
                  nil, nil,SW_SHOW);

        if( err <= 32 ) then
	case err of
        SE_ERR_NOASSOC:
        	MessageBox(0,'No default application to open the file','ERROR:',0);
        ERROR_FILE_NOT_FOUND:
        	MessageBox(0,'File not found','ERROR:',0);
        SE_ERR_ACCESSDENIED:
		MessageBox(0,'Access denied to open this file','ERROR:',0);
	ERROR_BAD_FORMAT:
		MessageBox(0,'Executable file format bad','ERROR:',0);
        SE_ERR_SHARE:
		MessageBox(0,'Sharing violation in opening this file','ERROR:',0);
	SE_ERR_OOM:
		MessageBox(0,'Not enough memory to open this file!','ERROR:',0);
        else
		MessageBox(0,'Error opening this file','ERROR:',0);
        end;
end;

{ Helper code for user friendliness }
procedure TForm1.resultsKeyPress(Sender: TObject; var Key: Char);
begin
	if (key = #13) or (key = #10) then
        begin
		resultsDblClick(Sender);
        end;
end;

{ Increment 'search time taken' label }
procedure TForm1.Timer1Timer(Sender: TObject);
begin
	timSecs.Caption := inttostr(strtoint(timSecs.Caption) + 1);
	if( length(timSecs.Caption) = 1 ) then
               	timSecs.Caption := '0' + timSecs.Caption;

	if( strtoint(timSecs.Caption) >= 60 ) then
        begin
        	timSecs.Caption := '00';
		timMins.Caption := inttostr(strtoint(timMins.Caption) + 1);
		if( length(timMins.Caption) = 1 ) then
                	timMins.Caption := '0' + timMins.Caption;
        end;
	if( strtoint(timMins.Caption) >= 60 ) then
	begin
        	timMins.Caption := '00';
		timHours.Caption := inttostr(strtoint(timHours.Caption) + 1);
		if( length(timHours.Caption) = 1 ) then
                	timHours.Caption := '0' + timHours.Caption;
	end;
	if( strtoint(timMins.Caption) >= 24 ) then
	begin
        	timHours.Caption := '00';
	end;
end;

{ Stop search thread upon close }
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	if( searchStarted ) then
		cmdSearchClick(Sender);
end;

{ Show the about dialog }
procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
	aboutunit.AboutDlg.Show;
end;

{ Save search results with some text formatting into a user selected file}
procedure TForm1.SpeedButton2Click(Sender: TObject);
var
	outf : TextFile;
        t, x, maxfnSize, maxfsSize : integer;
        itm : ^ItemData;
        tmpStr1, tmpStr2:string;
begin
	maxfnSize := 0; // Max FileName size
        maxfsSize := 0; // Max FileSize (string) size

	if( fileList.Count = 0 ) then
        begin
        	MessageBox(0,'Nothing to save!','Note:',0);
                exit;
        end;

	Savedlg.Execute;

	tmpStr1 := form1.status.Panels.Items[0].Text;
	tmpStr2 := form1.status.Panels.Items[1].Text;
	form1.status.Panels.Items[0].Text := 'Status:';
	form1.status.Panels.Items[1].Text := 'please wait, saving file...';
        form1.status.Repaint;

        AssignFile(outf,savedlg.Filename);
        Rewrite(outf);

        for t := 0 to fileList.Count-1 do
        begin
	       	itm := Pointer(fileList.Items[t]);
                if( length(itm^.caption) > maxfnSize ) then
                	maxfnSize := length(itm^.caption);
                if( length(itm^.Subitem1) > maxfsSize ) then
                	maxfsSize := length(itm^.subitem1);
        end;

        inc(maxfnSize,3);
        inc(maxfsSize,7);

        writeln(outf,'Power Search results:'+#13+#10);
        writeln(outf,'Directories included in search:');
        for t := 1 to length(dirsSearched) do
        	if( dirsSearched[t] = ';' ) then
                	writeln(outf)
                else
                	write(outf,dirsSearched[t]);
        writeln(outf,#13+#10);
        if( length(searchWildCards) > 0 ) then
	        writeln(outf,'Search wildcards: ['+searchWildCards+']'+#13+#10)
        else
	        writeln(outf,'Search wildcards: [everything]'+#13+#10);

        for t := 1 to (maxFsSize+maxFnSize+9) do write(outf,'-');
        writeln(outf);
        write(outf,'FileName');
        for t := 1 to (maxFnSize-8) do write(outf,' ');
        write(outf,'FileSize');
        for t := 1 to (maxFsSize-8) do write(outf,' ');
        writeln(outf,'Location');
        for t := 1 to (maxFsSize+maxFnSize+9) do write(outf,'-');
        writeln(outf);


        for t := 0 to fileList.Count-1 do
        begin
        	itm := Pointer(fileList.Items[t]);
                write(outf,itm^.caption);
	        for x := 1 to (maxFnSize-length(itm^.caption)) do write(outf,' ');
                write(outf,itm^.subitem1);
	        for x := 1 to (maxFsSize-length(itm^.subitem1)) do write(outf,' ');
                write(outf,itm^.subitem2);
                writeln(outf);
        end;

        writeln(outf);
        for t := 1 to (maxFsSize+maxFnSize+9) do write(outf,'-');
        writeln(outf);

        if( form1.optIncDirs.checked  ) then
	        write(outf,'Total files & directories found: ')
        else
	        write(outf,'Total files found: ');

        write(outf, fileList.Count);

        CloseFile(outf);

	form1.status.Panels.Items[0].Text := tmpStr1;
	form1.status.Panels.Items[1].Text := tmpStr2;
end;

{ Show up colorful 'hint' boxes actually displaying info
about a selected archive file }
procedure TForm1.resultsSelectItem(Sender: TObject; Item: TListItem;
 Selected: Boolean);
 var
 	t:integer;
begin
	if( not Selected ) then exit;
	hint := 'FileName: ' + Item.Caption + #13 + #10 +
		'FileSize: ' + Item.SubItems[0] + #13 + #10 +
		'FilePath: ' + Item.SubItems[1];

	for t:= 1 to length(hintcolors) do
        begin
        	if( Application.HintColor = hintColors[t] ) then
                begin
                	if( t = length(hintColors) ) then
                    		Application.HintColor := hintColors[1]
                        else
                    		Application.HintColor := hintColors[t+1];
                        break;
                end;
        end;

	Application.HideHint;
        Application.HintMouseMessage(results,mouseMsg);
end;

{ Helper code for user friendliness }
procedure TForm1.FormShow(Sender: TObject);
begin
	fileNames.SetFocus;
end;

{ Helper code for user friendliness }
procedure TForm1.WMMouseMove(var msg: TMessage);
begin
	mousemsg := msg;
end;


end.
